package nl.powercraft.tagtracker;


import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import android.os.Environment;
import android.util.Log;

public class FileHandler {
        
	public boolean init()
	{
		boolean mExternalStorageAvailable = false;
		boolean mExternalStorageWriteable = false;
		String state = Environment.getExternalStorageState();

		if (Environment.MEDIA_MOUNTED.equals(state)) {
		    // We can read and write the media
		    mExternalStorageAvailable = mExternalStorageWriteable = true;
		} else if (Environment.MEDIA_MOUNTED_READ_ONLY.equals(state)) {
		    // We can only read the media
		    mExternalStorageAvailable = true;
		    mExternalStorageWriteable = false;
		} else {
		    // Something else is wrong. It may be one of many other states, but all we need
		    //  to know is we can neither read nor write
		    mExternalStorageAvailable = mExternalStorageWriteable = false;
		}		
		
		if(mExternalStorageAvailable && mExternalStorageWriteable)
		{
			File root = new File(Environment.getExternalStorageDirectory(), "TagTracker");
			if (!root.exists()) {
	            root.mkdirs();
	        }
			return true;
		}
		else
		{
			return false;
		}
	}
	public void writeUID(String uid, String time)
	{
		try {
			File root = new File(Environment.getExternalStorageDirectory(), "TagTracker");
		    File xmlfile = new File(root, "tags.xml");
		    FileWriter writer = new FileWriter(xmlfile,true);
			String tag = 
	        		"	<tag uid=\"" + uid + "\">\r\n" +
	        		"		<time>" + time + "</time>\r\n" +
	        		"	</tag>\r\n";
	        writer.append(tag);
	        writer.flush();
	        writer.close();	
		} catch (IOException e) {
			Log.e("TagTracker", "" + e.getMessage());
		}
        	
	}
	
	public void writeNote(String note)
	{
		try {
			File root = new File(Environment.getExternalStorageDirectory(), "TagTracker");
		    File xmlfile = new File(root, "tags.xml");
		    FileWriter writer = new FileWriter(xmlfile,true);
			String tag = 
	        		"	<note>\r\n" +
	        		"	" + note +
	        		"	<note>\r\n";
	        writer.append(tag);
	        writer.flush();
	        writer.close();	
		} catch (IOException e) {
			Log.e("TagTracker", "" + e.getMessage());
		}
        	
	}
	public void writeStart(String starttime)
	{
		try
	    {
			File root = new File(Environment.getExternalStorageDirectory(), "TagTracker");
		    File xmlfile = new File(root, "tags.xml");
		    FileWriter writer = new FileWriter(xmlfile,false);
	        String start = 
	        		"<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n" +
	        		"<tags>\r\n" +
	        		"	<start time=\""+starttime+"\" />\r\n";
	        //Log.i("TagTracker", "Writing start...");
	        writer.write(start);
	        //Log.i("TagTracker", "Wrote start...");
	        writer.flush();
	        writer.close();
	    }
	    catch(IOException e)
	    {
	         Log.e("TagTracker", ""+ e.getMessage());
	    }		
	}
	public void writeEnd(String endtime)
	{
		try
	    {
			File root = new File(Environment.getExternalStorageDirectory(), "TagTracker");
		    File xmlfile = new File(root, "tags.xml");
		    FileWriter writer = new FileWriter(xmlfile,true);
	        String end =
	        		"	<end time=\""+endtime+"\" />\r\n" +
	        		"</tags>";
	        //Log.i("TagTracker", "Writing end...");
	        writer.append(end);
	        //Log.i("TagTracker", "Wrote end...");
	        writer.flush();
	        writer.close();
	    }
	    catch(IOException e)
	    {
	         Log.e("TagTracker", ""+ e.getMessage());
	    }		
	}
}
