package nl.deadpixel.tagtracker.beta;


import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentFilter.MalformedMimeTypeException;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.RingtoneManager;
import android.net.Uri;
import android.nfc.NfcAdapter;
import android.nfc.tech.NfcA;
import android.os.Bundle;
import android.os.Handler;
import android.os.PowerManager;
import android.os.PowerManager.WakeLock;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.ToggleButton;

public class TagTrackerActivity extends Activity {
	private NfcAdapter mAdapter;
    private PendingIntent mPendingIntent;
    private IntentFilter[] mFilters;
    private String[][] mTechLists;
    private FileHandler fh = new FileHandler();
    private boolean writeAllow = false;
    private ArrayList<String> cardID = new ArrayList<String>();
    private RelativeLayout mScreen;
    
    @Override
    public void onCreate(Bundle savedState) {
        super.onCreate(savedState);
        final PowerManager pm = (PowerManager) getSystemService(Context.POWER_SERVICE);
        WakeLock mWakeLock;
        setContentView(R.layout.main);
        final Button button = (Button) findViewById(R.id.zend);
        button.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
            
            }
        });
        mScreen = (RelativeLayout) findViewById(R.id.Screen);
        mWakeLock = pm.newWakeLock(PowerManager.SCREEN_DIM_WAKE_LOCK | PowerManager.ON_AFTER_RELEASE,"");    
        mWakeLock.acquire();
        mAdapter = NfcAdapter.getDefaultAdapter(this);

        // Create a generic PendingIntent that will be deliver to this activity. The NFC stack
        // will fill in the intent with the details of the discovered tag before delivering to
        // this activity.
        mPendingIntent = PendingIntent.getActivity(this, 0, new Intent(this, getClass()).addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP), 0);

        // Setup an intent filter for all MIME based dispatches
        IntentFilter tech = new IntentFilter(NfcAdapter.ACTION_TECH_DISCOVERED);
        try {
            tech.addDataType("*/*");
        } catch (MalformedMimeTypeException e) {
            throw new RuntimeException("fail", e);
        }
        mFilters = new IntentFilter[] {
               tech,
        };

        // Setup a tech list for all NfcF tags
        mTechLists = new String[][] { new String[] { NfcA.class.getName() } };
    }
    
    public void onToggleClicked(View v) {
        // Perform action on clicks
        if (((ToggleButton) v).isChecked()) {
        	if(fh.init())
            {
            	fh.writeStart(DateFormat.getDateTimeInstance().format(new Date()));
            	writeAllow = true;
            }
            else
            {
            	finish();
            }
        } else {
            fh.writeEnd(DateFormat.getDateTimeInstance().format(new Date()));
            writeAllow = false;
            cardID.clear();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (mAdapter != null) mAdapter.enableForegroundDispatch(this, mPendingIntent, mFilters,
                mTechLists);
    }

    @Override
    public void onNewIntent(Intent intent) {
    	if(writeAllow)
    	{
	    	byte[] bid = intent.getByteArrayExtra(NfcAdapter.EXTRA_ID); 
		    	try
		    	{
		    		String uid = getHexString(bid);
		    		String time = DateFormat.getDateTimeInstance().format(new Date());
		    		if(!cardID.contains(uid))
			    	{
			    		Log.i("Foreground dispatch", "Discovered tag with ID: " + uid);
			            //mText.append("\r\n["+time+"] Discovered tag " + ++mCount + " with ID: " + uid);
			            fh.writeUID(uid, time, "");
			            cardID.add(uid);
			            setBackground(0xFF00FF00, 200);
			    	}
			    	else
			    	{
			    		setBackground(0xFFFF0000, 1000);
			    		playSound(this.getApplicationContext());
			    		//mText.append("\r\n["+time+"] Tag ID " + uid + " is already added.");
			    	}
		    	}
		    	catch (Exception e)
		    	{
		    		Log.e("TagTracker", "" + e);
		    	}
    	}
    }
    public void playSound(Context context) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
		Uri soundUri = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);
		MediaPlayer mMediaPlayer = new MediaPlayer();
		mMediaPlayer.setDataSource(context, soundUri);
		final AudioManager audioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
		int originalVolume  = audioManager.getStreamVolume(AudioManager.STREAM_ALARM);
		int maxVolume = audioManager.getStreamMaxVolume(AudioManager.STREAM_ALARM);
		audioManager.setStreamVolume(AudioManager.STREAM_ALARM, maxVolume, AudioManager.FLAG_REMOVE_SOUND_AND_VIBRATE);
		mMediaPlayer.setAudioStreamType(AudioManager.STREAM_ALARM);
		mMediaPlayer.setLooping(false);
		mMediaPlayer.prepare();
		mMediaPlayer.start();
		if(!mMediaPlayer.isPlaying())
		{
			audioManager.setStreamVolume(AudioManager.STREAM_ALARM, originalVolume, AudioManager.FLAG_REMOVE_SOUND_AND_VIBRATE);
		}
    }
    
    public static String getHexString(byte[] b) throws Exception {
    	  String result = "";
    	  for (int i=0; i < b.length; i++) {
    	    result +=
    	          Integer.toString( ( b[i] & 0xff ) + 0x100, 16).substring( 1 );
    	  }
    	  return result;
    	}
    
    public void setBackground(int color, int time)
    {
    	mScreen.setBackgroundColor(color);
    	Handler handler = new Handler(); 
        handler.postDelayed(new Runnable() { 
             public void run() { 
            	mScreen.setBackgroundColor(android.R.color.white); 
             } 
        }, time); 
    	
    	
    }
    @Override
    public void onPause() {
        super.onPause();
        if (mAdapter != null) mAdapter.disableForegroundDispatch(this);
    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.lo_menu, menu);
        return true;
    }
}